@echo off
setlocal enabledelayedexpansion

:: Verifica se PySide6 está instalado
python -c "import PySide6" 2>nul
if %errorlevel% neq 0 (
    echo PySide6 não encontrado. Instalando...
    pip install PySide6
) else (
    echo PySide6 já instalado. Continuando...
)

:: Criar script de conversão usando pyside6-lrelease
echo import os, subprocess > converter.py
echo for file in os.listdir("."): >> converter.py
echo     if file.endswith(".ts"): >> converter.py
echo         qm_file = file.replace(".ts", ".qm") >> converter.py
echo         result = subprocess.run(["pyside6-lrelease", file, "-qm", qm_file], capture_output=True, text=True) >> converter.py
echo         if os.path.exists(qm_file): >> converter.py
echo             print(f"Convertido corretamente: {file} -> {qm_file}") >> converter.py
echo         else: >> converter.py
echo             print(f"Erro ao converter: {file}\n{result.stderr}") >> converter.py

:: Executar a conversão
python converter.py

:: Limpar o script Python após a execução
del converter.py

echo Conversão concluída!
pause
